/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xregcons.c 
 * -----------------------------------------------------------------*/


#include <xpciapi.h>

#define COMPILING_REGCONST_C
#include <xregcons.h>
#undef COMPILING_REGCONST_C

/* SCR; 12.97; mechanism to permit code to operate with one of 2 different
 * register address sets...(i.e. unaltered 2925 and 2926).
 * Note that the register set arrays are uni-dimensional for speed.
 */

const bx_int32 RegPciXCommand              = 0xABUL; 
const bx_int32 RegBestXStatusMini         = 0xACUL;
const bx_int32 RegXBoardRstmode            = 0xADUL;
const bx_int32 RegBiosVersionNumber       = 0x04UL;
const bx_int32 RegXProductString           = 0x02UL;
const bx_int32 RegXDummyRegister           = 0x0AUL;


/* actual register widths for a 2926 */

const MULT_REG_WIDTHS bx_regsize[256] = {

  /* BestXControl Registers (0x00 .. 0x0F) */
  /* this first block requires a byte register size in any case!! CZ */

  {BX_SIZE_BYTE}   ,     /* 00 */
  {BX_SIZE_BYTE}   ,     /* 01 */
    {BX_SIZE_BYTE}   ,                /* 02 RPRODUCT_STRING...both MUST be BYTE !!! */
  {BX_SIZE_BYTE}   ,     /* 03 */
  {BX_SIZE_BYTE}   ,     /* 04 */
  {BX_SIZE_BYTE}   ,     /* 05 */
  {BX_SIZE_BYTE}   ,     /* 06 */
  {BX_SIZE_BYTE}   ,     /* 07 */
  {BX_SIZE_BYTE}   ,     /* 08 */
  {BX_SIZE_BYTE}   ,     /* 09 */
  {BX_SIZE_BYTE}   ,     /* 0A */
  {BX_SIZE_BYTE}   ,     /* 0B */
  {BX_SIZE_BYTE}   ,     /* 0C */
  {BX_SIZE_BYTE}   ,     /* 0D */
  {BX_SIZE_BYTE}   ,     /* 0E */
   {BX_SIZE_BYTE}   ,     /* 0F */

  /* PCI Programming Registers (0x10 .. 0x1F) */

    {BX_SIZE_DWORD}  ,     /* 10 */
    {BX_SIZE_DWORD}  ,     /* 11 */
    {BX_SIZE_BYTE}   ,     /* 12 */
    {BX_SIZE_BYTE}   ,     /* 13 */
    {BX_SIZE_DWORD}  ,     /* 14 */
    {BX_SIZE_DWORD}  ,     /* 15 */
    {BX_SIZE_DWORD}  ,     /* 16 */
    {BX_SIZE_DWORD}  ,     /* 17 */
    {BX_SIZE_DWORD}  ,     /* 18 */
    {BX_SIZE_DWORD}  ,     /* 19 */
    {BX_SIZE_BYTE}   ,     /* 1A */
    {BX_SIZE_BYTE}   ,     /* 1B */
    {BX_SIZE_BYTE}   ,     /* 1C */
    {BX_SIZE_BYTE}   ,     /* 1D */
    {BX_SIZE_BYTE}   ,     /* 1E */
    {BX_SIZE_DWORD}  ,     /* 1F */

  /* MasterSeqControl (0x20 .. 0x2F) */
  /* 26 core: programming flash */
    {BX_SIZE_BYTE}           ,     /* 20 */
  {BX_SIZE_BYTE}  ,     /* 21 */
  {BX_SIZE_BYTE}  ,     /* 22 */
  {BX_SIZE_BYTE}  ,     /* 23 */
    {BX_SIZE_BYTE}           ,     /* 24 */
    {BX_SIZE_BYTE}          ,     /* 25 */
    {BX_SIZE_BYTE}          ,     /* 26 */
    {BX_SIZE_BYTE}           ,     /* 27 */
    {BX_SIZE_BYTE}           ,     /* 28 */
    {BX_SIZE_BYTE}          ,     /* 29 */
    {BX_SIZE_BYTE}           ,     /* 2A */
  {BX_SIZE_BYTE} ,     /* 2B */
  {BX_SIZE_BYTE} ,     /* 2C */
  {BX_SIZE_BYTE} ,     /* 2D */
  {BX_SIZE_BYTE} ,     /* 2E */
  {BX_SIZE_BYTE} ,     /* 2F */

  /* ConfigSpaceAccess (0x30 .. 0x3F) */

    {BX_SIZE_DWORD}  ,     /* 30 */
    {BX_SIZE_DWORD}  ,     /* 31 */
    {BX_SIZE_DWORD}  ,     /* 32 */
    {BX_SIZE_BYTE}   ,     /* 33 */
    {BX_SIZE_BYTE}   ,     /* 34 */
    {BX_SIZE_DWORD}  ,     /* 35 */
    {BX_SIZE_DWORD}  ,     /* 36 */
    {BX_SIZE_DWORD}  ,     /* 37 */
    {BX_SIZE_DWORD}  ,     /* 38 */
    {BX_SIZE_DWORD}  ,     /* 39 */
    {BX_SIZE_DWORD}  ,     /* 3A */
    {BX_SIZE_DWORD}  ,     /* 3B */
    {BX_SIZE_DWORD}  ,     /* 3C */
    {BX_SIZE_DWORD}  ,     /* 3D */
    {BX_SIZE_DWORD}  ,     /* 3E */
    {BX_SIZE_DWORD}  ,     /* 3F */

  /* PCIProtocolObserver (0x40 .. 0x4F) */

    {BX_SIZE_DWORD}  ,     /* 40 */
    {BX_SIZE_DWORD}  ,     /* 41 */
    {BX_SIZE_DWORD}  ,     /* 42 */
    {BX_SIZE_BYTE}   ,     /* 43 */
    {BX_SIZE_BYTE}   ,     /* 44 */
    {BX_SIZE_BYTE}   ,     /* 45 */
    {BX_SIZE_BYTE}   ,     /* 46 */
    {BX_SIZE_BYTE}   ,     /* 47 */
    {BX_SIZE_BYTE}   ,     /* 48 */
    {BX_SIZE_DWORD}  ,     /* 49 */
    {BX_SIZE_DWORD}  ,     /* 4A */
    {BX_SIZE_DWORD}  ,     /* 4B */
    {BX_SIZE_DWORD}  ,     /* 4C */
    {BX_SIZE_DWORD}  ,     /* 4D */
    {BX_SIZE_DWORD}  ,     /* 4E */
    {BX_SIZE_DWORD}  ,     /* 4F */

  /* PCIExpansionROMAccess (0x50 .. 0x5F) */

    {BX_SIZE_DWORD}  ,     /* 50 */
    {BX_SIZE_BYTE}   ,     /* 51 */
    {BX_SIZE_BYTE}   ,     /* 52 */
    {BX_SIZE_DWORD}  ,     /* 53 */
    {BX_SIZE_DWORD}  ,     /* 54 */
    {BX_SIZE_DWORD}  ,     /* 55 */
    {BX_SIZE_DWORD}  ,     /* 56 */
    {BX_SIZE_DWORD}  ,     /* 57 */
    {BX_SIZE_DWORD}  ,     /* 58 */
    {BX_SIZE_DWORD}  ,     /* 59 */
    {BX_SIZE_DWORD}  ,     /* 5A */
    {BX_SIZE_DWORD}  ,     /* 5B */
    {BX_SIZE_DWORD}  ,     /* 5C */
    {BX_SIZE_DWORD}  ,     /* 5D */
    {BX_SIZE_DWORD}  ,     /* 5E */
    {BX_SIZE_DWORD}  ,     /* 5F */

  /* RAMAccess Registers (0x60 .. 0x6F) */

    {BX_SIZE_DWORD}  ,     /* 60 */
    {BX_SIZE_DWORD}  ,     /* 61 */
    {BX_SIZE_BYTE}   ,     /* 62 */
    {BX_SIZE_DWORD}  ,     /* 63 */
    {BX_SIZE_DWORD}  ,     /* 64 */
    {BX_SIZE_DWORD}  ,     /* 65 */
    {BX_SIZE_DWORD}  ,     /* 66 */
    {BX_SIZE_DWORD}  ,     /* 67 */
    {BX_SIZE_DWORD}  ,     /* 68 */
    {BX_SIZE_DWORD}  ,     /* 69 */
    {BX_SIZE_DWORD}  ,     /* 6A */
    {BX_SIZE_DWORD}  ,     /* 6B */
    {BX_SIZE_DWORD}  ,     /* 6C */
    {BX_SIZE_DWORD}  ,     /* 6D */
    {BX_SIZE_DWORD}  ,     /* 6E */
    {BX_SIZE_DWORD}  ,     /* 6F */

  /* LogicAnalyzer Registers (0x70 .. 0x7F) */

    {BX_SIZE_WORD}   ,     /* 70 */
    {BX_SIZE_BYTE}   ,     /* 71 */
    {BX_SIZE_BYTE}   ,     /* 72 */
    {BX_SIZE_DWORD}  ,     /* 73 */
    {BX_SIZE_DWORD}  ,     /* 74 */
    {BX_SIZE_DWORD}  ,     /* 75 */
    {BX_SIZE_BYTE}   ,     /* 76 */
    {BX_SIZE_DWORD}  ,     /* 77 */
    {BX_SIZE_BYTE}   ,     /* 78 */
    {BX_SIZE_BYTE}   ,     /* 79 */
    {BX_SIZE_BYTE}   ,     /* 7A */
    {BX_SIZE_WORD}   ,     /* 7B */
    {BX_SIZE_BYTE}   ,     /* 7C */
    {BX_SIZE_DWORD}  ,     /* 7D */
    {BX_SIZE_DWORD}  ,     /* 7E */
    {BX_SIZE_DWORD}  ,     /* 7F */

  /* AttributeMemAccess  (0x80 .. 0x8F) */

    {BX_SIZE_DWORD}  ,     /* 80 */
    {BX_SIZE_DWORD}  ,     /* 81 */
    {BX_SIZE_DWORD}  ,     /* 82 */
    {BX_SIZE_DWORD}  ,     /* 83 */
    {BX_SIZE_DWORD}  ,     /* 84 */
    {BX_SIZE_DWORD}  ,     /* 85 */
    {BX_SIZE_DWORD}  ,     /* 86 */
    {BX_SIZE_BYTE}   ,     /* 87 */
    {BX_SIZE_BYTE}   ,     /* 88 */
    {BX_SIZE_DWORD}  ,     /* 89 */
    {BX_SIZE_DWORD}  ,     /* 8A */
    {BX_SIZE_DWORD}  ,     /* 8B */
    {BX_SIZE_DWORD}  ,     /* 8C */
    {BX_SIZE_DWORD}  ,     /* 8D */
    {BX_SIZE_DWORD}  ,     /* 8E */
    {BX_SIZE_DWORD}  ,     /* 8F */

  /* Display Registers (0x90 .. 0x9F) */

    {BX_SIZE_BYTE}   ,     /* 90 */
    {BX_SIZE_BYTE}   ,     /* 91 */
    {BX_SIZE_BYTE}   ,     /* 92 */
    {BX_SIZE_DWORD}  ,     /* 93 */
    {BX_SIZE_BYTE}   ,     /* 94 */
    {BX_SIZE_BYTE}   ,     /* 95 */
    {BX_SIZE_BYTE}   ,     /* 96 */
    {BX_SIZE_DWORD}  ,     /* 97 */
    {BX_SIZE_DWORD}  ,     /* 98 */
    {BX_SIZE_DWORD}  ,     /* 99 */
    {BX_SIZE_DWORD}  ,     /* 9A */
    {BX_SIZE_DWORD}  ,     /* 9B */
    {BX_SIZE_DWORD}  ,     /* 9C */
    {BX_SIZE_BYTE}   ,     /* 9D */
    {BX_SIZE_BYTE}   ,     /* 9E */
    {BX_SIZE_DWORD}  ,     /* 9F */

  /* Sideband Port Register (0xA0 .. 0xAF) */

    {BX_SIZE_DWORD}  ,     /* A0 */
    {BX_SIZE_BYTE}   ,     /* A1 */
    {BX_SIZE_BYTE}   ,     /* A2 */
    {BX_SIZE_DWORD}  ,     /* A3 */
    {BX_SIZE_DWORD}  ,     /* A4 */
    {BX_SIZE_DWORD}  ,     /* A5 */
    {BX_SIZE_DWORD}  ,     /* A6 */
    {BX_SIZE_DWORD}  ,     /* A7 */
    {BX_SIZE_DWORD}  ,     /* A8 */
    {BX_SIZE_DWORD}  ,     /* A9 */
    {BX_SIZE_DWORD}  ,     /* AA */
  {BX_SIZE_WORD}   ,     /* AB */
    {BX_SIZE_DWORD}  ,     /* AC */
  {BX_SIZE_BYTE}   ,     /* AD */
    {BX_SIZE_DWORD}  ,     /* AE */
  {BX_SIZE_BYTE}   ,     /* AF */

  /* CPU Port Registers (0xB0 .. 0xBF) */

    {BX_SIZE_BYTE}   ,     /* B0 */
    {BX_SIZE_WORD}   ,     /* B1 */
    {BX_SIZE_DWORD}  ,     /* B2 */
    {BX_SIZE_BYTE}   ,     /* B3 */
    {BX_SIZE_BYTE}   ,     /* B4 */
    {BX_SIZE_BYTE}   ,     /* B5 */
    {BX_SIZE_BYTE}   ,     /* B6 */
    {BX_SIZE_BYTE}   ,     /* B7 */
    {BX_SIZE_BYTE}   ,     /* B8 */
    {BX_SIZE_DWORD}  ,     /* B9 */
    {BX_SIZE_DWORD}  ,     /* BA */
    {BX_SIZE_DWORD}  ,     /* BB */
    {BX_SIZE_DWORD}  ,     /* BC */
    {BX_SIZE_DWORD}  ,     /* BD */
    {BX_SIZE_DWORD}  ,     /* BE */
    {BX_SIZE_DWORD}  ,     /* BF */

  /* Architecture Download (0xC0 .. 0xCF)  */

    {BX_SIZE_BYTE}   ,     /* C0         CORE: BYTE */
    {BX_SIZE_BYTE}   ,     /* C1         CORE: BYTE */
    {BX_SIZE_DWORD}  ,     /* C2         CORE: DWORD */
    {BX_SIZE_DWORD}  ,     /* C3         CORE: DWORD */
    {BX_SIZE_BYTE}   ,     /* C4         CORE: BYTE */
    {BX_SIZE_BYTE}   ,     /* C5         CORE: BYTE, do NOT use this!!! */
    {BX_SIZE_BYTE}   ,     /* C6         CORE: BYTE */
    {BX_SIZE_WORD}   ,     /* C7 */
    {BX_SIZE_BYTE}   ,     /* C8 */
    {BX_SIZE_DWORD}  ,     /* C9 */
    {BX_SIZE_DWORD}  ,     /* CA */
    {BX_SIZE_DWORD}  ,     /* CB */
    {BX_SIZE_DWORD}  ,     /* CC */
    {BX_SIZE_DWORD}  ,     /* CD */
    {BX_SIZE_DWORD}  ,     /* CE */
    {BX_SIZE_DWORD}  ,     /* CF */

  /* Miscellaneous Registers (0xD0 .. 0xFF) */

    {BX_SIZE_DWORD}  ,     /* D0 */
    {BX_SIZE_DWORD}  ,     /* D1 */
    {BX_SIZE_DWORD}  ,     /* D2 */
    {BX_SIZE_DWORD}  ,     /* D3 */
    {BX_SIZE_DWORD}  ,     /* D4 */
    {BX_SIZE_BYTE}   ,     /* D5 */
    {BX_SIZE_BYTE}   ,     /* D6 */
    {BX_SIZE_DWORD}  ,     /* D7 */
    {BX_SIZE_BYTE}   ,     /* D8 */
    {BX_SIZE_BYTE}   ,     /* D9 */
    {BX_SIZE_BYTE}   ,     /* DA */
    {BX_SIZE_BYTE}   ,     /* DB */
    {BX_SIZE_BYTE}   ,     /* DC */
    {BX_SIZE_BYTE}   ,     /* DD */
    {BX_SIZE_BYTE}   ,     /* DE */
    {BX_SIZE_DWORD}  ,     /* DF */

    {BX_SIZE_DWORD}  ,     /* E0 */
    {BX_SIZE_DWORD}  ,     /* E1 */
    {BX_SIZE_BYTE}   ,     /* E2 */
    {BX_SIZE_DWORD}  ,     /* E3 */
    {BX_SIZE_DWORD}  ,     /* E4 */
    {BX_SIZE_DWORD}  ,     /* E5 */
    {BX_SIZE_DWORD}  ,     /* E6 */
    {BX_SIZE_DWORD}  ,     /* E7 */
    {BX_SIZE_DWORD}  ,     /* E8 */
    {BX_SIZE_DWORD}  ,     /* E9 */
    {BX_SIZE_BYTE}   ,     /* EA */
    {BX_SIZE_BYTE}   ,     /* EB */
    {BX_SIZE_BYTE}   ,     /* EC */
    {BX_SIZE_BYTE}   ,     /* ED */
    {BX_SIZE_BYTE}   ,     /* EE */
    {BX_SIZE_BYTE}   ,     /* EF */

    {BX_SIZE_DWORD}      ,     /* F0 */
    {BX_SIZE_BYTE}               ,     /* F1 */
    {BX_SIZE_DWORD}              ,     /* F2 */
    {BX_SIZE_BYTE}               ,     /* F3 */
    {BX_SIZE_DWORD}              ,     /* F4 */
    {BX_SIZE_DWORD}              ,     /* F5 */
    {BX_SIZE_DWORD}              ,     /* F6 */
    {BX_SIZE_DWORD}              ,     /* F7 */
    {BX_SIZE_DWORD}              ,     /* F8 */
    {BX_SIZE_BYTE}               ,     /* F9 */
    {BX_SIZE_BYTE}               ,     /* FA */
    {BX_SIZE_BYTE}               ,     /* FB */
    {BX_SIZE_DWORD}              ,     /* FC */
    {BX_SIZE_DWORD}              ,     /* FD */
    {BX_SIZE_BYTE}               ,     /* FE */
    {BX_SIZE_DWORD}                  /* FF */

};
